require File.dirname(__FILE__) + '/../unit_test_helper'

describe "Dorm" do
  fixtures :dorms, :users
  
  it "has available rooms when it has fewer users than beds" do
    dorm = dorms(:epworth)
    dorm.stubs(:users).returns([])
    dorm.available_beds?.should == true
  end
  
  it "has no available rooms when it has as many users as beds" do
    dorm = dorms(:epworth)
    dorm.stubs(:users).returns(Array.new(75))
    dorm.available_beds?.should == false
  end
  
  it "has no available rooms when it has more users than beds" do
    dorm = dorms(:epworth)
    dorm.stubs(:users).returns(Array.new(100))
    dorm.available_beds?.should == false  
  end
  
  it "allows a user to move in when it has available beds" do
    dorm = dorms(:epworth)
    dorm.stubs(:users).returns([])
    dorm.move_in(users(:justin)).should.be dorm
  end
  
  it "does not allow a user to move in when it has no available beds" do
    dorm = dorms(:epworth)
    dorm.stubs(:users).returns(Array.new(75))
    lambda {dorm.move_in(users(:justin))}.should.raise(RuntimeError).message.should == "Can't move in, no available beds."
  end
  
end