class Section < ActiveRecord::Base
  has_many :enrollments
  has_many :users, :through => :enrollments
  has_one :waitlist
  
  def available_seats?
    users.size < seats
  end
  
  def enroll(student)
    if available_seats?
      users << student
      self
    else
      waitlist ||= Waitlist.create
      waitlist.enroll(student)
      waitlist
    end
  end
end
