class User < ActiveRecord::Base
  has_many :enrollments
  has_many :sections, :through => :enrollments
  has_many :waitings
  has_many :waiting_sections, :through => :waitings, :source => :sections
  
  def to_s
    "#{last_name}, #{first_name}"
  end
  
  
  def preferences
    @preferences ||= Preference.find_by_cas_user(cas_user)
  end
  
  def fav_color
    preferences.text_color || '#000000'
  end
  
end
