require File.dirname(__FILE__) + '/../unit_test_helper'

describe "User" do
  fixtures :sections, :users
  
  
  it "returns true when students less than seats" do
    section = sections(:cs)
    section.stubs(:users).returns([])
    section.available_seats?.should == true
  end
  
  it "returns false when students == seats" do
    section = sections(:cs)    
    section.stubs(:users).returns(Array.new(10))
    section.available_seats?.should == false
  end
  
  it "returns false when students > seats" do
    section = sections(:cs)
    section.stubs(:users).returns(Array.new(11))
    section.available_seats?.should == false    
  end
  
  it "enrolls student when there are available seats" do
    section = sections(:cs)    
    section.enroll(users(:justin)).should.be section
    section.users.should.include(users(:justin))
  end
  
  it "creates a waitlist and puts student on it when there are not available seats" do
    section = sections(:cs)    
    section.stubs(:users).returns(Array.new(11))
    section.waitlist.should == nil
    waitlist = section.enroll(users(:justin))
    waitlist.class.should.be Waitlist
    waitlist.users.should.include(users(:justin))
  end
  
end